<div class="modal-dialog modal-xl" role="document">
	<div class="modal-content">
		<div class="modal-header">
		    <button type="button" class="close no-print" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		      <h4 class="modal-title" id="modalTitle"><?php echo e($product->name, false); ?></h4>
	    </div>
	    <div class="modal-body">
      		<div class="row">
      			<div class="col-sm-9">
	      			<div class="col-sm-4 invoice-col">
						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.sku'); ?>:</b>
							<span><?php echo e($product->sku, false); ?></span>
						</div>
						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.brand'); ?>: </b>
							<span><?php echo e($product->brand->name ?? '--', false); ?></span>
						</div>
						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.unit'); ?>: </b>
							<span><?php echo e($product->unit->short_name ?? '--', false); ?></span>
						</div>
						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.barcode_type'); ?>: </b>
							<span>
								<?php echo e($product->barcode_type ?? '--', false); ?>

							</span>
						</div>
						<?php
    						$custom_labels = json_decode(session('business.custom_labels'), true);
						?>
						<?php if(!empty($product->product_custom_field1)): ?>
							<div class="invoice-col-box">
								<b><?php echo e($custom_labels['product']['custom_field_1'] ?? __('lang_v1.product_custom_field1'), false); ?>: </b>
								<span><?php echo e($product->product_custom_field1, false); ?></span>
							</div>
						<?php endif; ?>

						<?php if(!empty($product->product_custom_field2)): ?>
							<div class="invoice-col-box">
								<b><?php echo e($custom_labels['product']['custom_field_2'] ?? __('lang_v1.product_custom_field2'), false); ?>: </b>
								<span><?php echo e($product->product_custom_field2, false); ?></span>
							</div>
						<?php endif; ?>

						<?php if(!empty($product->product_custom_field3)): ?>
							<div class="invoice-col-box">
								<b><?php echo e($custom_labels['product']['custom_field_3'] ?? __('lang_v1.product_custom_field3'), false); ?>: </b>
								<span>
									<?php echo e($product->product_custom_field3, false); ?>

								</span>
							</div>
						<?php endif; ?>

						<?php if(!empty($product->product_custom_field4)): ?>
							<div class="invoice-col-box">
								<b><?php echo e($custom_labels['product']['custom_field_4'] ?? __('lang_v1.product_custom_field4'), false); ?>: </b>
								<span><?php echo e($product->product_custom_field4, false); ?></span>
							</div>
						<?php endif; ?>
						<b><?php echo app('translator')->getFromJson('lang_v1.available_in_locations'); ?>:</b>
						<?php if(count($product->product_locations) > 0): ?>
							<?php echo e(implode(', ', $product->product_locations->pluck('name')->toArray()), false); ?>

						<?php else: ?>
							<?php echo app('translator')->getFromJson('lang_v1.none'); ?>
						<?php endif; ?>
						<?php if(!empty($product->media->first())): ?> <br>
							<b><?php echo app('translator')->getFromJson('lang_v1.product_brochure'); ?>:</b>
							<a href="<?php echo e($product->media->first()->display_url, false); ?>" download="<?php echo e($product->media->first()->display_name, false); ?>">
								<span class="label label-info">
									<i class="fas fa-download"></i>
									<?php echo e($product->media->first()->display_name, false); ?>

								</span>
							</a>
						<?php endif; ?>
	      			</div>

	      			<div class="col-sm-4 invoice-col">
						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.category'); ?>: </b>
							<span>
								<?php echo e($product->category->name ?? '--', false); ?>

							</span>
						</div>
						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.sub_category'); ?>: </b>
							<span>
								<?php echo e($product->sub_category->name ?? '--', false); ?>

							</span>
						</div>

						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.manage_stock'); ?>: </b>
							<span>
								<?php if($product->enable_stock): ?>
									<?php echo app('translator')->getFromJson('messages.yes'); ?>
								<?php else: ?>
									<?php echo app('translator')->getFromJson('messages.no'); ?>
								<?php endif; ?>
							</span>
						</div>

						<?php if($product->enable_stock): ?>
							<div class="invoice-col-box">
								<b><?php echo app('translator')->getFromJson('product.alert_quantity'); ?>: </b>
								<span>
									<?php echo e($product->alert_quantity ?? '--', false); ?>

								</span>
							</div>
						<?php endif; ?>

						<?php if(!empty($product->warranty)): ?>
						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('lang_v1.warranty'); ?>: </b>
							<span>
								<?php echo e($product->warranty->display_name, false); ?>

							</span>
						</div>
						<?php endif; ?>

	      			</div>

	      			<div class="col-sm-4 invoice-col">
						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.expires_in'); ?>: </b>
							<span>
								<?php
									$expiry_array = ['months'=>__('product.months'), 'days'=>__('product.days'), '' =>__('product.not_applicable') ];
								?>
								<?php if(!empty($product->expiry_period) && !empty($product->expiry_period_type)): ?>
									<?php echo e($product->expiry_period, false); ?> <?php echo e($expiry_array[$product->expiry_period_type], false); ?>

								<?php else: ?>
									<?php echo e($expiry_array[''], false); ?>

								<?php endif; ?>
							</span>
						</div>



						<?php if($product->weight): ?>
							<div class="invoice-col-box">
								<b><?php echo app('translator')->getFromJson('lang_v1.weight'); ?>: </b>
								<span><?php echo e($product->weight, false); ?></span>
							</div>
						<?php endif; ?>

						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.applicable_tax'); ?>: </b>
							<span>
								<?php echo e($product->product_tax->name ?? __('lang_v1.none'), false); ?>

							</span>
						</div>

						<?php
							$tax_type = ['inclusive' => __('product.inclusive'), 'exclusive' => __('product.exclusive')];
						?>

						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.selling_price_tax_type'); ?>: </b>
							<span>
								<?php echo e($tax_type[$product->tax_type], false); ?>

							</span>
						</div>

						<div class="invoice-col-box">
							<b><?php echo app('translator')->getFromJson('product.product_type'); ?>: </b>
							<span>
								<?php echo app('translator')->getFromJson('lang_v1.' . $product->type); ?>
							</span>
						</div>




	      			</div>
	      			<div class="clearfix"></div>
	      			<br>
      				<div class="col-sm-12">
      					<div class="product-name">
							<?php echo $product->product_description; ?>

						</div>
      				</div>
	      		</div>
      			<div class="col-sm-3 col-md-3 invoice-col">
      				<div class="thumbnail">
      					<img src="<?php echo e($product->image_url, false); ?>" alt="Product image">
      				</div>
      			</div>
      		</div>
      		<?php if($rack_details->count()): ?>
      		<?php if(session('business.enable_racks') || session('business.enable_row') || session('business.enable_position')): ?>
      			<div class="row">
      				<div class="col-md-12">
      					<h4><?php echo app('translator')->getFromJson('lang_v1.rack_details'); ?>:</h4>
      				</div>
      				<div class="col-md-12">
      					<div class="table-responsive">
      					<table class="table table-condensed bg-gray">
      						<tr class="">
      							<th><?php echo app('translator')->getFromJson('business.location'); ?></th>
      							<?php if(session('business.enable_racks')): ?>
      								<th><?php echo app('translator')->getFromJson('lang_v1.rack'); ?></th>
      							<?php endif; ?>
      							<?php if(session('business.enable_row')): ?>
      								<th><?php echo app('translator')->getFromJson('lang_v1.row'); ?></th>
      							<?php endif; ?>
      							<?php if(session('business.enable_position')): ?>
      								<th><?php echo app('translator')->getFromJson('lang_v1.position'); ?></th>
      							<?php endif; ?>
      							</tr>
      						<?php $__currentLoopData = $rack_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      							<tr>
	      							<td><?php echo e($rd->name, false); ?></td>
	      							<?php if(session('business.enable_racks')): ?>
	      								<td><?php echo e($rd->rack, false); ?></td>
	      							<?php endif; ?>
	      							<?php if(session('business.enable_row')): ?>
	      								<td><?php echo e($rd->row, false); ?></td>
	      							<?php endif; ?>
	      							<?php if(session('business.enable_position')): ?>
	      								<td><?php echo e($rd->position, false); ?></td>
	      							<?php endif; ?>
      							</tr>
      						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      					</table>
      					</div>
      				</div>
      			</div>
      		<?php endif; ?>
      		<?php endif; ?>
      		<?php if($product->type == 'single'): ?>
      			<?php echo $__env->make('product.partials.single_product_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      		<?php elseif($product->type == 'variable'): ?>
      			<?php echo $__env->make('product.partials.variable_product_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      		<?php elseif($product->type == 'combo'): ?>
      			<?php echo $__env->make('product.partials.combo_product_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      		<?php endif; ?>
      		<?php if($product->enable_stock == 1): ?>
	      		<div class="row">
	      			<div class="col-md-12">
	      				<strong><?php echo app('translator')->getFromJson('lang_v1.product_stock_details'); ?></strong>
	      			</div>
	      			<div class="col-md-12 mt-5" id="view_product_stock_details" data-product_id="<?php echo e($product->id, false); ?>">
	      			</div>
	      		</div>
      		<?php endif; ?>
      	</div>
      	<div class="modal-footer">
      		<button type="button" class="btn btn-primary no-print"
	        aria-label="Print"
	          onclick="$(this).closest('div.modal').printThis();">
	        <i class="fa fa-print"></i> <?php echo app('translator')->getFromJson( 'messages.print' ); ?>
	      </button>
	      	<button type="button" class="btn btn-default no-print" data-dismiss="modal"><?php echo app('translator')->getFromJson( 'messages.close' ); ?></button>
	    </div>
	</div>
</div>
<?php /**PATH C:\laragon\www\pos3\resources\views/product/view-modal.blade.php ENDPATH**/ ?>