<div class="modal-dialog modal-xl" role="document">
	<div class="modal-content">
		<div class="modal-header">
		    <button type="button" class="close no-print" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
		      <h4 class="modal-title" id="modalTitle">{{$product->name}}</h4>
	    </div>
	    <div class="modal-body">
      		<div class="row">
      			<div class="col-sm-9">
	      			<div class="col-sm-4 invoice-col">
						<div class="invoice-col-box">
							<b>@lang('product.sku'):</b>
							<span>{{$product->sku }}</span>
						</div>
						<div class="invoice-col-box">
							<b>@lang('product.brand'): </b>
							<span>{{$product->brand->name ?? '--' }}</span>
						</div>
						<div class="invoice-col-box">
							<b>@lang('product.unit'): </b>
							<span>{{$product->unit->short_name ?? '--' }}</span>
						</div>
						<div class="invoice-col-box">
							<b>@lang('product.barcode_type'): </b>
							<span>
								{{$product->barcode_type ?? '--' }}
							</span>
						</div>
						@php
    						$custom_labels = json_decode(session('business.custom_labels'), true);
						@endphp
						@if(!empty($product->product_custom_field1))
							<div class="invoice-col-box">
								<b>{{ $custom_labels['product']['custom_field_1'] ?? __('lang_v1.product_custom_field1') }}: </b>
								<span>{{$product->product_custom_field1 }}</span>
							</div>
						@endif

						@if(!empty($product->product_custom_field2))
							<div class="invoice-col-box">
								<b>{{ $custom_labels['product']['custom_field_2'] ?? __('lang_v1.product_custom_field2') }}: </b>
								<span>{{$product->product_custom_field2 }}</span>
							</div>
						@endif

						@if(!empty($product->product_custom_field3))
							<div class="invoice-col-box">
								<b>{{ $custom_labels['product']['custom_field_3'] ?? __('lang_v1.product_custom_field3') }}: </b>
								<span>
									{{$product->product_custom_field3 }}
								</span>
							</div>
						@endif

						@if(!empty($product->product_custom_field4))
							<div class="invoice-col-box">
								<b>{{ $custom_labels['product']['custom_field_4'] ?? __('lang_v1.product_custom_field4') }}: </b>
								<span>{{$product->product_custom_field4 }}</span>
							</div>
						@endif
						<b>@lang('lang_v1.available_in_locations'):</b>
						@if(count($product->product_locations) > 0)
							{{implode(', ', $product->product_locations->pluck('name')->toArray())}}
						@else
							@lang('lang_v1.none')
						@endif
						@if(!empty($product->media->first())) <br>
							<b>@lang('lang_v1.product_brochure'):</b>
							<a href="{{$product->media->first()->display_url}}" download="{{$product->media->first()->display_name}}">
								<span class="label label-info">
									<i class="fas fa-download"></i>
									{{$product->media->first()->display_name}}
								</span>
							</a>
						@endif
	      			</div>

	      			<div class="col-sm-4 invoice-col">
						<div class="invoice-col-box">
							<b>@lang('product.category'): </b>
							<span>
								{{$product->category->name ?? '--' }}
							</span>
						</div>
						<div class="invoice-col-box">
							<b>@lang('product.sub_category'): </b>
							<span>
								{{$product->sub_category->name ?? '--' }}
							</span>
						</div>

						<div class="invoice-col-box">
							<b>@lang('product.manage_stock'): </b>
							<span>
								@if($product->enable_stock)
									@lang('messages.yes')
								@else
									@lang('messages.no')
								@endif
							</span>
						</div>

						@if($product->enable_stock)
							<div class="invoice-col-box">
								<b>@lang('product.alert_quantity'): </b>
								<span>
									{{$product->alert_quantity ?? '--' }}
								</span>
							</div>
						@endif

						@if(!empty($product->warranty))
						<div class="invoice-col-box">
							<b>@lang('lang_v1.warranty'): </b>
							<span>
								{{$product->warranty->display_name }}
							</span>
						</div>
						@endif

	      			</div>

	      			<div class="col-sm-4 invoice-col">
						<div class="invoice-col-box">
							<b>@lang('product.expires_in'): </b>
							<span>
								@php
									$expiry_array = ['months'=>__('product.months'), 'days'=>__('product.days'), '' =>__('product.not_applicable') ];
								@endphp
								@if(!empty($product->expiry_period) && !empty($product->expiry_period_type))
									{{$product->expiry_period}} {{$expiry_array[$product->expiry_period_type]}}
								@else
									{{$expiry_array['']}}
								@endif
							</span>
						</div>



						@if($product->weight)
							<div class="invoice-col-box">
								<b>@lang('lang_v1.weight'): </b>
								<span>{{$product->weight }}</span>
							</div>
						@endif

						<div class="invoice-col-box">
							<b>@lang('product.applicable_tax'): </b>
							<span>
								{{$product->product_tax->name ?? __('lang_v1.none') }}
							</span>
						</div>

						@php
							$tax_type = ['inclusive' => __('product.inclusive'), 'exclusive' => __('product.exclusive')];
						@endphp

						<div class="invoice-col-box">
							<b>@lang('product.selling_price_tax_type'): </b>
							<span>
								{{$tax_type[$product->tax_type]  }}
							</span>
						</div>

						<div class="invoice-col-box">
							<b>@lang('product.product_type'): </b>
							<span>
								@lang('lang_v1.' . $product->type)
							</span>
						</div>




	      			</div>
	      			<div class="clearfix"></div>
	      			<br>
      				<div class="col-sm-12">
      					<div class="product-name">
							{!! $product->product_description !!}
						</div>
      				</div>
	      		</div>
      			<div class="col-sm-3 col-md-3 invoice-col">
      				<div class="thumbnail">
      					<img src="{{$product->image_url}}" alt="Product image">
      				</div>
      			</div>
      		</div>
      		@if($rack_details->count())
      		@if(session('business.enable_racks') || session('business.enable_row') || session('business.enable_position'))
      			<div class="row">
      				<div class="col-md-12">
      					<h4>@lang('lang_v1.rack_details'):</h4>
      				</div>
      				<div class="col-md-12">
      					<div class="table-responsive">
      					<table class="table table-condensed bg-gray">
      						<tr class="">
      							<th>@lang('business.location')</th>
      							@if(session('business.enable_racks'))
      								<th>@lang('lang_v1.rack')</th>
      							@endif
      							@if(session('business.enable_row'))
      								<th>@lang('lang_v1.row')</th>
      							@endif
      							@if(session('business.enable_position'))
      								<th>@lang('lang_v1.position')</th>
      							@endif
      							</tr>
      						@foreach($rack_details as $rd)
      							<tr>
	      							<td>{{$rd->name}}</td>
	      							@if(session('business.enable_racks'))
	      								<td>{{$rd->rack}}</td>
	      							@endif
	      							@if(session('business.enable_row'))
	      								<td>{{$rd->row}}</td>
	      							@endif
	      							@if(session('business.enable_position'))
	      								<td>{{$rd->position}}</td>
	      							@endif
      							</tr>
      						@endforeach
      					</table>
      					</div>
      				</div>
      			</div>
      		@endif
      		@endif
      		@if($product->type == 'single')
      			@include('product.partials.single_product_details')
      		@elseif($product->type == 'variable')
      			@include('product.partials.variable_product_details')
      		@elseif($product->type == 'combo')
      			@include('product.partials.combo_product_details')
      		@endif
      		@if($product->enable_stock == 1)
	      		<div class="row">
	      			<div class="col-md-12">
	      				<strong>@lang('lang_v1.product_stock_details')</strong>
	      			</div>
	      			<div class="col-md-12 mt-5" id="view_product_stock_details" data-product_id="{{$product->id}}">
	      			</div>
	      		</div>
      		@endif
      	</div>
      	<div class="modal-footer">
      		<button type="button" class="btn btn-primary no-print"
	        aria-label="Print"
	          onclick="$(this).closest('div.modal').printThis();">
	        <i class="fa fa-print"></i> @lang( 'messages.print' )
	      </button>
	      	<button type="button" class="btn btn-default no-print" data-dismiss="modal">@lang( 'messages.close' )</button>
	    </div>
	</div>
</div>
